<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePartnershipContactsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('partnership_contacts', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('name');
            $table->string('second_name')->nullable();
            $table->string('second_last_name')->nullable();
            $table->string('email', 128)->nullable();
            $table->string('comments', 512)->nullable();
            
            $table->unsignedBigInteger('partnership_id');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('partnership_id')->references('id')
                ->on('partnerships');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('partnership_contacts');
    }
}
