<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRetentionToBusinessClients extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('business_clients', function (Blueprint $table) {
            $table->double('retention')->nullable(true);
        });
        Schema::table('invoices', function (Blueprint $table) {
            $table->double('retention')->nullable(true);
        });
        Schema::table('invoice_concepts', function (Blueprint $table) {
            $table->double('retention')->nullable(true);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('business_clients', function (Blueprint $table) {
            $table->removeColumn('retention');
        });
        Schema::table('invoices', function (Blueprint $table) {
            $table->removeColumn('retention');
        });
        Schema::table('invoice_concepts', function (Blueprint $table) {
            $table->removeColumn('retention');
        });
    }
}
