<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvoicePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_payments', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->unsignedBigInteger('invoice_id')->nullable();
            $table->unsignedBigInteger('invoice_related_id')->nullable();
            $table->string('pay_method', 32);
            $table->double('amount');
            $table->double('last_amount');
            $table->double('carried_amount');
            $table->integer('parciality');

            $table->foreign('invoice_id')->references('id')
                ->on('invoices');
            $table->foreign('invoice_related_id')->references('id')
                ->on('invoices');
            
            $table->dateTime('payment_at')->nullable();
            $table->timestamps();

            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_payments');
    }
}
