<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvoiceConceptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_concepts', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('code', 32)->nullable(true);
            $table->unsignedBigInteger('business_client_concept_id')->nullable(true);
            $table->string('concept', 128)->nullable(true);
            $table->string('description', 512)->nullable(true);
            $table->double('total')->nullable(true);
            $table->double('subtotal')->nullable(true);

            $table->unsignedBigInteger('invoice_id');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_concepts');
    }
}
