<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('code', 32)->nullable();
            $table->string('uuid')->nullable();
            $table->unsignedBigInteger('emissor_id');
            $table->unsignedBigInteger('receiver_id');
            $table->unsignedBigInteger('business_branch_id');
            $table->unsignedBigInteger('invoice_tax_regime_id');
            $table->unsignedBigInteger('invoice_type_id');
            $table->unsignedBigInteger('invoice_use_id');
            $table->string('pay_method', 32);
            $table->unsignedBigInteger('invoice_pay_type_id');
            $table->string('log')->nullable();

            $table->double('total');
            $table->double('subtotal');
            
            $table->datetime('invoice_at');
            $table->dateTime('stamped_at')->nullable();
            $table->dateTime('canceled_at')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('emissor_id')->references('id')
                ->on('business_clients');
            $table->foreign('receiver_id')->references('id')
                ->on('business_clients');
            $table->foreign('business_branch_id')->references('id')
                ->on('business_branches');
            $table->foreign('invoice_pay_type_id')->references('id')
                ->on('invoice_pay_types');
            $table->foreign('invoice_tax_regime_id')->references('id')
                ->on('invoice_tax_regimes');
            $table->foreign('invoice_type_id')->references('id')
                ->on('invoice_types');
            $table->foreign('invoice_use_id')->references('id')
                ->on('invoice_uses');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
