<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBusinessClientConceptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('business_client_concepts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('code', 64);
            $table->string('name');
            $table->unsignedBigInteger('business_client_id');

            $table->timestamps();
            $table->softDeletes();
            
            $table->foreign('business_client_id')->references('id')
                ->on('business_clients');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('business_client_concepts');
    }
}
