<?php

use App\Model\BusinessClient;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTypeToBusinessClientTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('business_clients', function (Blueprint $table) {
            $table->string('type', 5)->nullable();
            $table->string('address', 512)->nullable();

            $table->string('prefix')->nullable()->change();
            $table->dropUnique('business_clients_code_unique');
        });
        BusinessClient::whereNull('type')->update(['type' => 'I']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('business_clients', function (Blueprint $table) {
            $table->removeColumn('type');
            $table->removeColumn('address');
        });
    }
}
