<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProcessRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('process_requests', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('code');
            $table->string('status', 5);
            $table->string('command');
            $table->integer('progress');
            $table->timestamp('expired_at');
            $table->string('description', 512);
            $table->string('link_code')->nullable();

            $table->unsignedBigInteger('user_id');
            
            $table->timestamps();
            $table->foreign('user_id')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('process_requests');
    }
}
