<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('name');
            $table->string('last_name')->nullable();
            $table->string('last_name2')->nullable();
            $table->string('rfc');
            $table->string('curp');
            $table->string('employee_number');
            $table->unsignedBigInteger('business_client_id');
            
            $table->datetime('canceled_at')->nullable();
            $table->timestamps();

            $table->foreign('business_client_id')->references('id')
                ->on('business_clients');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees');
    }
}
