<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePayrollReceiptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payroll_receipts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('payroll_id');
            $table->string('code')->nullable();
            $table->string('uuid')->nullable();
            $table->string('name');
            $table->string('last_name')->nullable();
            $table->string('last_name2')->nullable();
            $table->string('rfc');
            $table->string('curp');
            
            $table->string('work_days');
            $table->double('subtotal');
            $table->double('isr');
            $table->double('total');
            $table->string('pay_period');
            $table->string('department')->nullable();
            $table->string('log')->nullable();

            $table->datetime('invoice_date');
            $table->datetime('pay_date');
            $table->datetime('pay_init');
            $table->datetime('pay_end');

            $table->dateTime('stamped_at')->nullable();
            $table->dateTime('canceled_at')->nullable();
            $table->timestamps();

            $table->foreign('payroll_id')->references('id')
                ->on('payrolls');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payroll_receipts');
    }
}
