<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePayrollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('import_code');
            $table->string('rfc');
            $table->string('name');
            $table->string('branch');
            $table->string('postal_code');
            $table->string('pay_period');

            $table->unsignedBigInteger('business_client_id');
            $table->unsignedBigInteger('isr_period_id');

            $table->dateTime('canceled_at')->nullable();
            $table->timestamps();
            
            $table->foreign('business_client_id')->references('id')
                ->on('business_clients');
            $table->foreign('isr_period_id')->references('id')
                ->on('isr_periods');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payrolls');
    }
}
