<?php

use App\Model\IsrPeriodDetails;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateIsrPeriodDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('isr_period_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->double('lower_limit');
            $table->double('uper_limit')->nullable();
            $table->double('fixed_fee');
            $table->double('percent');
            
            $table->unsignedBigInteger('isr_period_id');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('isr_period_id')->references('id')
                ->on('isr_periods');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('isr_period_details');
    }
}
