<?php

use App\Model\BusinessDepartment;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBusinessDepartmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('business_departments', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('code')->unique();
            $table->string('name');
            $table->string('email');
            
            $table->unsignedBigInteger('business_client_id');

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('business_client_id')->references('id')
                ->on('business_clients');
        });

        $department = new BusinessDepartment();
        $department->business_client_id = 1;
        $department->code = '001';
        $department->name = 'Finanzas';
        $department->email = 'd.maximo@silifalcon.com';
        $department->save();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('business_departments');
    }
}
