<?php

use App\Model\BusinessBranch;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBusinessBranchesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('business_branches', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('name');
            $table->string('prefix');
            $table->string('postal_code');

            $table->unsignedBigInteger('business_client_id');

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('business_client_id')->references('id')
                ->on('business_clients');
        });

        $branch = new BusinessBranch();
        $branch->business_client_id = 1;
        $branch->name = 'Puebla';
        $branch->prefix = 'PUE';
        $branch->postal_code = '72000';
        $branch->save();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('business_branches');
    }
}
