<?php

use App\Model\BusinessClient;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBusinessClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('business_clients', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('code')->unique();
            $table->string('name');
            $table->string('rfc');
            $table->string('prefix');
            $table->string('certificate_file')->nullable();
            $table->string('key_file')->nullable();
            $table->string('password_file')->nullable();
            
            $table->datetime('canceled_at')->nullable();
            $table->timestamps();
        });

        $business = new BusinessClient();
        $business->code = 'FAC_MOD';
        $business->name = 'FACTURACIÓN MODERNA S.A. DE C.V.';
        $business->rfc = 'MSE061107IA8';
        $business->prefix = 'MOD';
        $business->certificate_file = 'certificate.cer';
        $business->key_file = 'private.key';
        $business->password_file = 'password.txt';

        $business->save();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('business_clients');
    }
}
