<?php

namespace App;

use App\Model\Authorization;
use App\Model\Partnership;
use App\Model\UserAuthorization;
use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    
    protected $auths = null;

    private function getAuths() {
        return Authorization::join('user_authorizations', 
            'user_authorizations.authorization_id', '=', 'authorizations.id')
            ->where('user_authorizations.user_id', Auth::id())
            ->whereNull('user_authorizations.deleted_at')
            ->select('authorizations.*')
            ->with('categoryAuthorization')
            ->get();
    }

    public function hasAuth($authCode) {
        if ($this->auths == null) {
            $this->auths = $this->getAuths();
        }
        foreach ($this->auths as $auth) {
            if ($auth->code == $authCode) {
                return true;
            }
        }
        return false;
    }

    public function hasCategory($name) {
        if ($this->auths == null) {
            $this->auths = $this->getAuths();
        }
        foreach ($this->auths as $auth) {
            if ($auth->categoryAuthorization->name == $name) {
                return true;
            }
        }
        return false;
    }

    /**
     * Loads partnership related to user
     * @return mixed 
     */
    public function partnership() {
        return Partnership::join('partnership_contacts', 
            'partnership_contacts.partnership_id', '=', 'partnerships.id')
            ->join('users', 'users.id', '=', 'partnership_contacts.user_id')
            ->where('users.id', Auth::id())
            ->select('partnerships.*')
            ->first();
    }

    /**
     * Creates a full name
     */
    public function getFullName() {
        $name = trim($this->name);
        if ($this->last_name) {
            $name .= ' ' . trim($this->last_name);
        }
        if ($this->second_last_name) {
            $name .= ' ' . trim($this->second_last_name);
        }
        return $name;
    }
}
