<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WorkerReceiptReduction extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'deleted_at', 'created_at', 'updated_at'
    ];
    
    /**
     * Loads request related to deposit
     * @return BelongsTo 
     */
    public function payrollWorkerReceipt() {
        return $this->belongsTo(PayrollWorkerReceipt::class);
    }

}
