<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserAuthorization extends Model
{
    
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates
     */
    protected $dates = [
        'created_at', 'updated_at', 'deleted_at'
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function authorization() {
        return $this->belongsTo(Authorization::class);
    }

}
