<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\Log;
use SebastianBergmann\Environment\Console;

class User extends Authenticatable
{
    
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates
     */
    protected $dates = [
        'created_at', 'updated_at', 'deleted_at'
    ];

    /**
     * Creates a full name
     */
    public function getFullName() {
        $name = trim($this->name);
        if ($this->last_name) {
            $name .= ' ' . trim($this->last_name);
        }
        if ($this->second_last_name) {
            $name .= ' ' . trim($this->second_last_name);
        }
        return $name;
    }

    /**
     * Get type description
     * @return string 
     */
    public function getType() {
        if ($this->type == 'BI') {
            return 'Facturación';
        } else if ($this->type == 'BA') {
            return 'Banco';
        } else if ($this->type == 'CU') {
            return 'Cliente';
        }
        return '';
    }

    /**
     * Loads business clients related to employee
     */
    public function userAuthorizations() {
        return $this->hasMany(UserAuthorization::class);
    }

    /**
     * Retrieves if is active the employee on specified business
     * @param mixed $businessId business
     * @return bool 
     */
    public function isActive($authId) {
        return $this->userAuthorizations()->where('authorization_id', $authId)
            ->count() > 0;
    }

}
