<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class ScatterDetail extends Model
{
    /**
     * The attributes that should be mutated to dates
     */
    protected $dates = [
        'created_at', 'updated_dat'
    ];

    /**
     * Loads request related to employee scatter
     */
    public function employeeScatter() {
        return $this->belongsTo(EmployeeScatter::class)->with('employee');
    }

    public function requestFile() {
        return $this->belongsTo(RequestFile::class);
    }
    
    public function isNew() {
        return !$this->status || $this->status == '';
    }

    public function isSending() {
        return $this->status == 'O';
    }

    public function isOpen() {
        return $this->status != 'R';
    }

    public function canFactureApprove() {
        return $this->fac_status != 'A' && $this->status != 'F';
    }

    public function canBankApprove() {
        return $this->bank_status != 'A' && $this->status != 'F';
    }

    public function isReleased() {
        return $this->status == 'R';
    }
}
