<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class RequestInvoiceConcept extends Model
{
    
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'canceled_at', 'created_at', 'updated_at'
    ];

    /**
     * Loads request invoice related to concept
     * @return BelongsTo 
     */
    public function requestInvoice() {
        return $this->belongsTo(RequestInvoice::class);
    }

    /**
     * Loads partnership concept related to concept details
     * @return BelongsTo 
     */
    public function partnershipConcept() {
        return $this->belongsTo(PartnershipConcepts::class);
    }
    
}
