<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class RequestInvoice extends Model
{
    
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'canceled_at', 'created_at', 'updated_at'
    ];

    /**
     * Loads request related to deposit
     * @return BelongsTo 
     */
    public function request() {
        return $this->belongsTo(Request::class);
    }

    /**
     * Loads internal business client related
     * @return BelongsTo 
     */
    public function emissor() {
        return $this->belongsTo(BusinessClient::class, 'emissor_id');
    }

    /**
     * Loads external business client related
     * @return BelongsTo 
     */
    public function receiver() {
        return $this->belongsTo(BusinessClient::class, 'receiver_id');
    }

    /**
     * Loads external business client related
     * @return BelongsTo 
     */
    public function deposit() {
        return $this->belongsTo(RequestDeposit::class, 'request_deposit_id');
    }

    /**
     * Loads concepts related
     * @return BelongsTo 
     */
    public function concepts() {
        return $this->hasMany(RequestInvoiceConcept::class);
    }
}
