<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class RequestFile extends Model
{
    
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'created_at', 'updated_at'
    ];

    /**
     * Loads Payroll header
     */
    public function request() {
        return $this->belongsTo(Request::class);
    }

    /**
     * Gets a voucher file name
     * @return mixed 
     */
    public function getNameFileAttribute() {
        if ($this->file) {
            $dir = explode("/", $this->file);
            return $dir[count($dir) - 1];
        }
        return '';
    }

    /**
     * Gets a voucher file name
     * @return mixed 
     */
    public function getVoucherFile() {
        if ($this->file) {
            return substr($this->file, 
                strlen($this->request->businessClient->partnership->code) + 10 + strlen($this->id));
        }
        return '';
    }

}
