<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class RequestDeposit extends Model
{

    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'canceled_at', 'created_at', 'updated_at'
    ];

    /**
     * Loads request related to deposit
     * @return BelongsTo 
     */
    public function request() {
        return $this->belongsTo(Request::class);
    }

    /**
     * Loads external business client related
     * @return BelongsTo 
     */
    public function origin() {
        return $this->belongsTo(BusinessClient::class, 'origin_id');
    }

    /**
     * Loads internal business client related
     * @return BelongsTo 
     */
    public function destination() {
        return $this->belongsTo(BusinessClient::class, 'destination_id');
    }

    /**
     * Loads invoices related
     */
    public function invoices() {
        return $this->hasMany(RequestInvoice::class, 'request_deposit_id');
    }

    /**
     * loads current invoice
     * @return mixed 
     */
    public function getInvoiceAttribute() {
        if (count($this->invoices) > 0) {
            return $this->invoices[0];
        }
        return null;
    }

    /**
     * Gets a voucher file name
     * @return mixed 
     */
    public function getVoucherFile() {
        if ($this->voucher_file) {
            return substr($this->voucher_file, 
            strlen($this->request->businessClient->partnership->code) + 10 + strlen($this->id));
        }
        return '';
    }

    public function calcInvoices() {
        $invoices = $this->invoices;
        foreach ($invoices as $invoice) {
            $concepts = $invoice->concepts;
            $total = 0;
            foreach ($concepts as $concept) {
                $total += $concept->amount;
            }
            $invoice->amount = $total;
            $invoice->save();
        }
    }

    public function getTotalAttribute() {
        $invoices = $this->invoices;
        $total = 0;
        foreach ($invoices as $invoice) {
            $concepts = $invoice->concepts;
            foreach ($concepts as $concept) {
                $total += $concept->amount;
            }
        }
        return $total;
    }
}
