<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ReceiptEmployeeScatter extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'deleted_at', 'created_at', 'updated_at'
    ];
    
    /**
     * Loads employee scatter
     */
    public function employeeScatter() {
        return $this->belongsTo(EmployeeScatter::class);
    }

    /**
     * Loads employee scatter
     */
    public function employeeScatterWithRequest() {
        return $this->belongsTo(EmployeeScatter::class)->with('request');
    }

    /**
     * Loads Payroll receipt
     */
    public function payrollReceipt() {
        return $this->belongsTo(PayrollReceipt::class);
    }

}
