<?php

namespace App\Model;

use Carbon\Carbon;
use DateTime;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProcessRequest extends Model
{
    
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'expired_at', 'created_at', 'updated_at', 'deleted_at'
    ];

    public function open() {
        $this->status = 'O';
    }

    public function start() {
        $this->status = 'P';
    }

    public function finish() {
        $this->progress = 100;
        $this->status = 'D';
    }

    public function release() {
        $this->status = 'R';
    }

    public function setExpireAt($days) {
        $finishDate = Carbon::now();
        $finishDate->addHours(12);
        $finishDate->addDays($days);
        $this->expired_at = $finishDate;
    }

    /**
     * Loads user related to command
     */
    public function requestBy() {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function getOptionValue($option) {
        $option .= '=';
        $this->command .= ' ';
        return strstr(substr(strstr($this->command, $option), \strlen($option)), ' ', true);
    }

    public function getCommandName() {
        return strstr($this->command, ' ', true);
    }

    public function getType() {
        $command = $this->getCommandName();
        if ($command === 'bb:stamp-assimilated') {
            return 'Timbrado';
        } else if ($command === 'bb:export-receipts') {
            return 'Empaquetado';
        }
        return '';
    }

    /**
     * Format user data
     */
    public function format() {
        return [
            'id' => $this->id,
            'code' => $this->code,
            'status' => $this->status,
            'command' => $this->command,
            'progress' => $this->progress,
            'description' => $this->description,
            'linkCode' => $this->link_code            
        ];
    }

}
