<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class PayrollWorker extends Model
{
    
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'payed_at', 'invoiced_at', 'pay_init', 'pay_end', 'removed_at', 'created_at', 'updated_at'
    ];

    /**
     * Loads Payroll header
     */
    public function request() {
        return $this->belongsTo(Request::class);
    }

    /**
     * Loads business client related to branch
     */
    public function businessClient() {
        return $this->belongsTo(BusinessClient::class);
    }

    /**
     * Loads business client related to branch
     */
    public function businessBranch() {
        return $this->belongsTo(BusinessBranch::class);
    }
    
    /**
     * Loads Payroll receipts
     */
    public function payrollWorkerReceipts() {
        return $this->hasMany(PayrollWorkerReceipt::class);
    }

    /**
     * Loads Payroll receipts
     */
    public function payrollWorkerReceiptsWithDeductions() {
        return $this->hasMany(PayrollWorkerReceipt::class)->with('workerReceiptReductions');
    }

    /**
     * Loads worker files
     * @return HasMany 
     */
    public function workerFiles() {
        return $this->hasMany(WorkerFile::class);
    }

    public function getReceipt($employeeId) {
        $receipts = $this->payrollWorkerReceiptsWithDeductions;
        foreach ($receipts as $receipt) {
            if ($receipt->employee_id == $employeeId) {
                return $receipt;
            }
        }
        return null;
    }

    public function getAsAttribute() {
        $as = 0;
        $receipts = $this->payrollWorkerReceipts;
        foreach ($receipts as $receipt) {
            $as += $receipt->as;
        }
        return $as;
    }

    public function getSysAttribute() {
        $sys = 0;
        $receipts = $this->payrollWorkerReceipts;
        foreach ($receipts as $receipt) {
            $sys += $receipt->sys;
        }
        return $sys;
    }

}
