<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class PayrollReceipt extends Model
{
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'pay_date', 'pay_init', 'pay_end', 'invoice_date', 'stamped_at',
        'canceled_at', 'removed_at', 'created_at', 'updated_at'
    ];

    /**
     * Loads Payroll header
     */
    public function payroll() {
        return $this->belongsTo(Payroll::class);
    }

    public function getFullName() {
        $name = trim($this->name);
        if ($this->last_name) {
            $name .= ' ' . trim($this->last_name);
        }
        if ($this->last_name2) {
            $name .= ' ' . trim($this->last_name2);
        }
        return $name;
    }

    public function getFullNameAttribute() {
        $name = trim($this->name);
        if ($this->last_name) {
            $name .= ' ' . trim($this->last_name);
        }
        if ($this->last_name2) {
            $name .= ' ' . trim($this->last_name2);
        }
        return $name;
    }

    public function isStamped() {
        return $this->uuid;
    }

    public function getStampPath() {
        if ($this->stamped_at) {
            $businessClient = $this->payroll->businessClient;
            return $businessClient->code . '/' . $this->stamped_at->format('Ymd') . '/';
        }
        return '';
    }

    public function getPeriodLegend() {
        $code = $this->pay_period;
        if ($code === '01') {
            return '01 Diario';
        }
        if ($code === '02') {
            return '02 Semanal';
        }
        if ($code === '03') {
            return '03 Catorcenal';
        }
        if ($code === '04') {
            return '04 Quincenal';
        }
        if ($code === '05') {
            return '05 Mensual';
        }
        if ($code === '06') {
            return '06 Bimestral';
        }
        if ($code === '07') {
            return '07 Unidad obra';
        }
        if ($code === '08') {
            return '08 Comisión';
        }
        if ($code === '09') {
            return '09 Precio alzado';
        }
        if ($code === '10') {
            return '10 Decenal';
        }
        if ($code === '99') {
            return '99 Otra Periodicidad';
        }
        return '';
    }

    /**
     * Format user data
     */
    public function format() {
        return [
            'id' => $this->id,
            'payRoll' => $this->payroll_id,
            'code' => $this->code,
            'uuid' => $this->uuid,
            'name' => $this->name,
            'lastName' => $this->last_name,
            'lastName2' => $this->last_name2,
            'rfc' => $this->rfc,
            'workDays' => $this->work_days,
            'subtotal' => $this->subtotal,
            'isr' => $this->isr,
            'total' => $this->total,
            'payPeriod' => $this->pay_period,
            'department' => $this->department,
            'claveEntFed' => $this->clave_ent_fed,
            'numEmpleado' => $this->num_empleado,
            'log' => $this->log,
            'invoiceDate' => $this->invoice_date,
            'payDate' => $this->pay_date,
            'payInit' => $this->pay_init,
            'payEnd' => $this->pay_end,
            'stampedAt' => $this->stamped_at
        ];
    }
}
