<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Payroll extends Model
{
    
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'canceled_at', 'created_at', 'updated_at'
    ];

    /**
     * Loads receipts relateds
     */
    public function payrollReceipts() {
        return $this->hasMany(PayrollReceipt::class);
    }

    /**
     * Loads business client related to branch
     */
    public function businessClient() {
        return $this->belongsTo(BusinessClient::class);
    }

    /**
     * Loads business client related to branch
     */
    public function businessBranch() {
        return $this->belongsTo(BusinessBranch::class);
    }

    /**
     * Loads Isr period related to payroll
     */
    public function isrPeriod() {
        return $this->belongsTo(IsrPeriod::class);
    }

    /**
     * Calcs status for payrolls
     */
    public function calcStatus() {
        $receipts = $this->payrollReceipts;
        $stampeds = 0;
        $valids = 0;
        foreach ($receipts as $r) {
            if ($r->isStamped()) {
                $stampeds ++;
            }
            if (!$r->canceled_at && !$r->removed_at) {
                $valids ++;
            }
        }

        if ($stampeds == $valids) {
            return '[' . $stampeds . '-' . $valids . '] Timbrado';
        } else if ($stampeds > 0) {
            return '[' . $stampeds . '-' . $valids . '] Timbrado parcial';
        }
        return '[' . $stampeds . '-' . $valids . '] No timbrado';
    }

    /**
     * calcs if the import has stamped receipts
     */
    public function hasStampedReceipts() {
        $receipts = $this->payrollReceipts;
        foreach ($receipts as $r) {
            if ($r->isStamped()) {
                return true;
            }
        }
        return false;
    }

    /**
     * Format user data
     */
    public function format() {
        return [
            'id' => $this->id,
            'importCode' => $this->import_code,
            'rfc' => $this->rfc,
            'name' => $this->name,
            'branch' => $this->business_branch_id,
            'postalCode' => $this->postal_code,
            'payPeriod' => $this->pay_period,
            'businessClient' => $this->business_client_id,
            'isrPeriod' => $this->isr_period_id
        ];
    }
}
