<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class PartnershipContact extends Model
{

    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'created_at', 'updated_at', 'deleted_at'
    ];

    /**
     * Loads partnership related to client
     */
    public function partnership() {
        return $this->belongsTo(Partnership::class);
    }

    /**
     * Loads user related to contact
     * @return BelongsTo 
     */
    public function user() {
        return $this->belongsTo(User::class);
    }

    /**
     * Creates a full name
     */
    public function getFullName() {
        $name = trim($this->name);
        if ($this->second_name) {
            $name .= ' ' . trim($this->second_name);
        }
        if ($this->second_last_name) {
            $name .= ' ' . trim($this->second_last_name);
        }
        return $name;
    }
}
