<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PartnershipConcepts extends Model
{
    use SoftDeletes;
    
    /**
     * The attributes that shoul be mutated to dates
     */
    protected $dates = [
        'created_at', 'updated_dat', 'deleted_at'
    ];

    /**
     * Loads business client related to branch
     */
    public function businessClient() {
        return $this->belongsTo(BusinessClient::class);
    }

    /**
     * Loads partnership related to concept
     */
    public function partnership() {
        return $this->belongsTo(Partnership::class);
    }
}
