<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Partnership extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'created_at', 'updated_at', 'deleted_at'
    ];

    /**
     * Loads branches related to client
     */
    public function businessClients() {
        return $this->hasMany(BusinessClient::class)->orderBy('name');
    }

    /**
     * Loads concepts related to partnership
     * @return concepts
     */
    public function partnershipConcepts() {
        return $this->hasMany(PartnershipConcepts::class);
    }

    /**
     * Loads contacts related to partnership
     */
    public function contacts() {
        return $this->hasMany(PartnershipContact::class);
    }

    public function IsActive($clientId) {
        return $this->hasMany(PartnershipConcepts::class)
            ->where('business_client_id', $clientId)
            ->where('status', '1')
            ->count() > 0;
    }

    public function HasConcepts($clientId) {
        return $this->hasMany(PartnershipConcepts::class)
        ->where('business_client_id', $clientId)
        ->count() > 0;
    }
}
