<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class IsrPeriod extends Model
{
    use SoftDeletes;

    protected $dates = [
        'created_at', 'updated_at', 'deleted_at'
    ];
    
    /**
     * Loads details related to isr period
     */
    public function details() {
        return $this->hasMany(IsrPeriodDetails::class);
    }

    /**
     * Loads subsidy details related to isr period
     */
    public function subsidyDetails() {
        return $this->hasMany(SubsidyDetail::class);
    }

    /**
     * Format user data
     */
    public function format() {
        $lowerLimit = [];
        $uperLimit = [];
        $fixedFee = [];
        $percent = [];
        foreach ($this->details as $det) {
            array_push($lowerLimit, $det->lower_limit);
            array_push($uperLimit, $det->uper_limit);
            array_push($fixedFee, $det->fixed_fee);
            array_push($percent, $det->percent);
        }
        return [
            'id' => $this->id,
            'name' => $this->name,
            'LowerLimits' => $lowerLimit,
            'UperLimits' => $uperLimit,
            'FixedFee' => $fixedFee,
            'Percent' => $percent,
        ];
    }

}
