<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Log;

class InvoiceConcept extends Model
{
    
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates
     */
    protected $dates = [
        'created_at', 'updated_at', 'deleted_at'
    ];

    /**
     * Retrieve the invoice header
     */
    public function invoice() {
        return $this->belongsTo(Invoice::class);
    }

    public function businessClientConcept() {
        return $this->belongsTo(BusinessClientConcept::class);
    }

    public function getCode() {
        if ($this->concept) {
            return $this->concept;
        }
        return $this->businessClientConcept->code;
    }

    public function getDescription() {
        $description = '';
        if ($this->businessClientConcept) {
            $description = $this->businessClientConcept->name;
        }
        if ($this->description) {
            return $description . ' ' . $this->description;
        } else if ($this->businessClientConcept) {
            return $description;
        }
        return null;
    }

}
