<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class EmployeeScatter extends Model
{
    
    /**
     * The attributes that should be mutated to dates
     */
    protected $dates = [
        'created_at', 'updated_dat'
    ];

    /**
     * Loads request related to employee scatter
     */
    public function request() {
        return $this->belongsTo(Request::class);
    }

    /**
     * Loads bank related to employee scatter
     */
    public function bank() {
        return $this->belongsTo(Bank::class);
    }
    
    /**
     * Loads employee relate to employee scatter
     */
    public function employee() {
        return $this->belongsTo(Employee::class);
    }

    /**
     * Loads employee relate to employee scatter
     */
    public function payrollWorkerReceipts() {
        return $this->hasMany(PayrollWorkerReceipt::class);
    }

    /**
     * Loads employee relate to employee scatter
     */
    public function scatterDetails() {
        return $this->hasMany(ScatterDetail::class)->with('requestFile');
    }

    public function hasEmployeeFiles() {
        $details = $this->scatterDetails;
        foreach ($details as $detail) {
            if ($detail->requestFile) {
                return true;
            }
        }
        return false;
    }

    public function getType() {
        if ($this->type == 'W') {
            return 'Trabajador';
        }
        return 'Colaborador';
    }
    
    public function HasCard() {
        return $this->account && strlen($this->account) == 16;
    }

    public function HasChangesBank() {
        return $this->bank_id != $this->employee->bank_id 
            || $this->account != $this->employee->account;
    }

    public function getReceiptAttribute() {
        $receipts = $this->payrollWorkerReceipts;
        if (count($receipts) > 0) {
            return $receipts[0];
        }
        return null;
    }

    public function hasFile($fileId) {
        $details = $this->scatterDetails;
        foreach ($details as $detail) {
            if ($detail->requestFile && $detail->requestFile->id == $fileId) {
                return true;
            }
        }
        return false;
    }

    public function getMissingPayment() {
        $amount = 0;
        $details = $this->scatterDetails;
        foreach ($details as $detail) {
            if ($detail->isReleased() && !$detail->requestFile) {
                $amount += $detail->amount;
            }
        }
        return $amount;
    }

    public function closePendingAmount() {
        $details = $this->scatterDetails;
        foreach ($details as $d) {
            if ($d->isOpen()) {
                $this->amount += $d->amount;
                $this->save();

                $d->fac_status = 'A';
                $d->bank_status = 'A';
                $d->status = 'R';
                $d->save();
            }
        }

        if ($this->employee->type == 'C') {
            $this->as = $this->amount;
        }
        $this->save();
    }

    public function sendPendingAmount() {
        $details = $this->scatterDetails;
        foreach ($details as $d) {
            if ($d->isNew()) {
                $d->status = 'O';
                $d->save();
            }
        }
    }

    public function hasSendingAmount() {
        $details = $this->scatterDetails;
        foreach ($details as $d) {
            if ($d->status == 'O') {
                return true;
            }
        }
        return false;
    }

    public function getScatterDetailOpen() {
        $details = $this->scatterDetails;
        foreach ($details as $d) {
            if ($d->isOpen()) {
                return $d;
            }
        }
        return null;
    }

    public function getPendingAmount() {
        $details = $this->scatterDetails;
        foreach ($details as $d) {
            if ($d->isOpen()) {
                return $d->amount;
            }
        }
        return 0;
    }

    public function getPendingAmountForAdmin() {
        $details = $this->scatterDetails;
        foreach ($details as $d) {
            if ($d->isSending()) {
                return $d->amount;
            }
        }
        return 0;
    }

    public function getPayedAmount() {
        $amount = 0;
        $details = $this->scatterDetails;
        foreach ($details as $d) {
            if ($d->request_file_id > 0) {
                $amount += $d->amount;
            }
        }
        return $amount;
    }

    public function getPendingAmountAttribute() {
        $details = $this->scatterDetails;
        foreach ($details as $d) {
            if ($d->isOpen()) {
                return $d->amount;
            }
        }
        return '';
    }

    public function addPendingAmount($amount) {
        if (!$this->id) {
            $this->amount = 0;
            $this->save();
        }
        $detail = new ScatterDetail();

        $details = $this->scatterDetails;
        foreach ($details as $d) {
            if ($d->isOpen()) {
                $detail = $d;
                break;
            }
        }
        $detail->employeeScatter()->associate($this);
        $detail->amount = $amount;
        $detail->save();
    }
}
