<?php

namespace App\Model;

use App\Http\Services\CatCFDIService;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

class Employee extends Model {
    
    /**
     * The attributes that should be mutated to dates
     */
    protected $dates = [
        'started_at', 'finished_at', 'created_at', 'updated_dat', 'deleted_at'
    ];

    /**
     * Loads partnership related to employee
     */
    public function partnership() {
        return $this->belongsTo(Partnership::class)->withTrashed();
    }

    /**
     * Loads business client related to employee
     */
    public function businessClient() {
        return $this->belongsTo(BusinessClient::class);
    }

    /**
     * Loads business clients related to employee
     */
    public function businessClients() {
        return $this->hasMany(BusinessClientEmployee::class);
    }

    public function BusinessClientEmployees() {
        return $this->hasMany(BusinessClientEmployee::class);
    }

    /**
     * Loads bank related to employee
     */
    public function bank() {
        return $this->belongsTo(Bank::class);
    }

    /**
     * Creates a full name
     */
    public function getFullName() {
        $name = trim($this->name);
        if ($this->last_name) {
            $name .= ' ' . trim($this->last_name);
        }
        if ($this->last_name2) {
            $name .= ' ' . trim($this->last_name2);
        }
        return $name;
    }

    /**
     * Gets full name employee
     * @return string
     */
    public function getFullNameAttribute() {
        $name = trim($this->name);
        if ($this->last_name) {
            $name .= ' ' . trim($this->last_name);
        }
        if ($this->last_name2) {
            $name .= ' ' . trim($this->last_name2);
        }
        return $name;
    }

    /**
     * Retrieves if is active the employee on specified business
     * @param mixed $businessId business
     * @return bool 
     */
    public function isActive($businessId) {
        return $this->businessClients()->where('business_client_id', $businessId)
            ->count() > 0;
    }

    public function getType() {
        if ($this->type == 'W') {
            return 'Trabajador';
        }
        return 'Colaborador';
    }

    public function getNameTypeAttribute() {
        if ($this->type == 'W') {
            return 'Trabajador';
        }
        return 'Colaborador';
    }

    public function getBusinessBranch() {
        $branches = $this->businessClient->branches;
        foreach ($branches as $b) {
            if ($b->prefix == $this->federative_key) {
                return $b;
            }
        }
        return null;
    }

    /**
     * Format user data
     */
    public function format() {
        return [
            'id' => $this->id,
            'name' => $this->getFullName(),
            'rfc' => $this->rfc,
            'curp' => $this->curp,
            'employeeNumber' => $this->employee_number,
            'partnership' => $this->partnership_id
        ];
    }

    /**
     * Gets a ine file name
     * @return mixed 
     */
    public function getIneFile() {
        if ($this->ine_file) {
            $dir = explode("/", $this->ine_file);
            return $dir[count($dir) - 1];
        }
        return '';
    }

    /**
     * Gets a ine file name
     * @return mixed 
     */
    public function getAddressFile() {
        if ($this->address_file) {
            $dir = explode("/", $this->address_file);
            return $dir[count($dir) - 1];
        }
        return '';
    }

    /**
     * Gets a rfc file name
     * @return mixed 
     */
    public function getRfcFile() {
        if ($this->rfc_file) {
            $dir = explode("/", $this->rfc_file);
            return $dir[count($dir) - 1];
        }
        return '';
    }

    /**
     * Gets a curp file name
     * @return mixed 
     */
    public function getCurpFile() {
        if ($this->curp_file) {
            $dir = explode("/", $this->curp_file);
            return $dir[count($dir) - 1];
        }
        return '';
    }

    /**
     * Gets a curp file name
     * @return mixed 
     */
    public function getInfonavitFile() {
        if ($this->infonavit_file) {
            $dir = explode("/", $this->infonavit_file);
            return $dir[count($dir) - 1];
        }
        return '';
    }

    /**
     * Gets a curp file name
     * @return mixed 
     */
    public function getNssFile() {
        if ($this->nss_file) {
            $dir = explode("/", $this->nss_file);
            return $dir[count($dir) - 1];
        }
        return '';
    }

    public function getStatusLabelAttribute() {
        if ($this->status == 'O') {
            return 'Abierto';
        } else if ($this->status == 'P') {
            return 'Pendiente';
        } else if ($this->status == 'R') {
            return 'Liberado';
        } else if ($this->status == 'F') {
            return 'Rechazado';
        }
        return '';
    }

    public function getContractTypeLabelAttribute() {
        $types = CatCFDIService::getContractTypes();
        foreach ($types as $t) {
            if ($t['key'] == $this->contract_type) {
                return $this->contract_type . ' - ' . $t['value'];
            }
        }
        return '';
    }

    public function getRegimeTypeLabelAttribute() {
        $types = CatCFDIService::getRegimeTypes();
        foreach ($types as $t) {
            if ($t['key'] == $this->regime_type) {
                return $this->regime_type . ' - ' . $t['value'];
            }
        }
        return '';
    }

    public function getWorkstationRiskLabelAttribute() {
        $types = CatCFDIService::getWorkstationRisks();
        foreach ($types as $t) {
            if ($t['key'] == $this->workstation_risk) {
                return $this->workstation_risk . ' - ' . $t['value'];
            }
        }
        return '';
    }
}
