<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CategoryAuthorization extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates
     */
    protected $dates = [
        'created_at', 'updated_at', 'deleted_at'
    ];

    /**
     * Parent authorization
     * @return Illuminate\Database\Eloquent\Relations\BelongsTo 
     */
    public function authorizations() {
        return $this->hasMany(Authorization::class);
    }
}
