<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BusinessDepartment extends Model
{
    
    use SoftDeletes;

    protected $dates = [
        'created_at', 'updated_at', 'deleted_at'
    ];

    /**
     * Loads business client related to department
     */
    public function businessClient() {
        return $this->belongsTo(BusinessClient::class);
    }

    /**
     * Format user data
     */
    public function format() {
        return [
            'id' => $this->id,
            'code' => $this->code,
            'name' => $this->name,
            'email' => $this->email,
            'prefix' => $this->prefix,
            'businessClient' => $this->business_client_id
        ];
    }
}
