<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BusinessClientEmployee extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'deleted_at', 'created_at', 'updated_at'
    ];
    
    /**
     * Loads businessClient related to a employee
     */
    public function businessClient() {
        return $this->belongsTo(BusinessClient::class);
    }

    /**
     * Loads employee related to a businesClient
     * @return Illuminate\Database\Eloquent\Relations\BelongsTo 
     */
    public function employee() {
        return $this->belongsTo(Employee::class);
    }
}
