<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BusinessClientConcept extends Model
{
    
    use SoftDeletes;
    
    protected $dates = [
        'created_at', 'updated_at', 'deleted_at'
    ];

    /**
     * Loads business client related to department
     */
    public function businessClient() {
        return $this->belongsTo(BusinessClient::class);
    }

}
