<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BusinessBranch extends Model
{
    use SoftDeletes;
    
    /**
     * The attributes that shoul be mutated to dates
     */
    protected $dates = [
        'created_at', 'updated_dat', 'deleted_at'
    ];

    /**
     * Loads business client related to branch
     */
    public function businessClient() {
        return $this->belongsTo(BusinessClient::class);
    }

    /**
     * Format branch data
     */
    public function format() {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'prefix' => $this->prefix,
            'postal_code' => $this->postal_code,
            'businessClient' => $this->business_client_id
        ];
    }
}
