<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class BankHistory extends Model
{
    
    /**
     * The attributes that shoul be mutated to dates
     */
    protected $dates = [
        'created_at', 'updated_dat'
    ];

    /**
     * Loads employee to history
     */
    public function employee() {
        return $this->belongsTo(Employee::class);
    }

    /**
     * Loads bank related to history
     */
    public function bank() {
        return $this->belongsTo(Bank::class);
    }

    /**
     * Loads request related to history
     */
    public function request() {
        return $this->belongsTo(Request::class);
    }

    /**
     * Loads user related to history
     */
    public function user() {
        return $this->belongsTo(User::class);
    }
}
