<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Authorization extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates
     */
    protected $dates = [
        'created_at', 'updated_at', 'deleted_at'
    ];

    /**
     * Parent authorization
     * @return Illuminate\Database\Eloquent\Relations\BelongsTo 
     */
    public function parent() {
        return $this->belongsTo(Authorization::class);
    }

    public function categoryAuthorization() {
        return $this->belongsTo(CategoryAuthorization::class);
    }
}
