<?php

namespace App;

use App\Model\Invoice;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InvoicePayment extends Model
{

    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates
     */
    protected $dates = [
        'payment_at', 'created_at', 'updated_at', 'deleted_at'
    ];

    public function invoice() {
        return $this->belongsTo(Invoice::class, 'invoice_id');
    }

    public function invoiceRelated() {
        return $this->belongsTo(Invoice::class, 'invoice_related_id');
    }

}
