<?php

namespace App\Http\Services;

use App\Model\ConfigCodes;

/**
 * Allow save codes
 */
class CodeService {

    public static function saveConfigCode($pattern, $type, $length) {
        $config = ConfigCodes::where('pattern', $pattern)
            ->where('type', $type)->get()->first();
        if (!$config) {
            $config = new ConfigCodes();
            $config->type = $type;
            $config->pattern = $pattern;
            $config->length = $length;
            $config->value = 0;
            $config->save();
        }
        return $config;
    }

    public static function getNext($pattern, $type) {        
        $config = CodeService::saveConfigCode($pattern, $type, 5);
        $next = $config->value + 1;
        $nextCode = '' . $next;
        $lenAct = strlen($nextCode);
        for (; $lenAct < $config->length; $lenAct ++) {
            $nextCode = '0' . $nextCode;
        }
        if ($config->length > 0) {
            return $pattern . $nextCode;
        }
        return $nextCode . $pattern;
    }

    public static function saveNext($pattern, $type, $length = 5) {
        $config = CodeService::saveConfigCode($pattern, $type, $length);
        $next = $config->value + 1;
        $config->value = $next;
        $config->save();

        $nextCode = '' . $next;
        $lenAct = strlen($nextCode);
        for (; $lenAct < $config->length; $lenAct ++) {
            $nextCode = '0' . $nextCode;
        }
        if ($config->length > 0) {
            return $pattern . $nextCode;
        }
        return $nextCode . $pattern;
    }
}