<?php

namespace App\Http\Services;

/**
 * Manage the cfdi catalogs
 */
class CatCFDIService {

    public static function getFederativeKeys() {
        return [
            ['key' => 'AGU', 'value' => 'Aguascalientes'],
            ['key' => 'BCN', 'value' => 'Baja California'],
            ['key' => 'BCS', 'value' => 'Baja California Sur'],
            ['key' => 'CAM', 'value' => 'Campeche'],
            ['key' => 'CHP', 'value' => 'Chiapas'],
            ['key' => 'CHH', 'value' => 'Chihuahua'],
            ['key' => 'COA', 'value' => 'Coahuila'],
            ['key' => 'COL', 'value' => 'Colima'],
            ['key' => 'DIF', 'value' => 'Ciudad de México'],
            ['key' => 'DUR', 'value' => 'Durango'],
            ['key' => 'GUA', 'value' => 'Guanajuato'],
            ['key' => 'GRO', 'value' => 'Guerrero'],
            ['key' => 'HID', 'value' => 'Hidalgo'],
            ['key' => 'JAL', 'value' => 'Jalisco'],
            ['key' => 'MEX', 'value' => 'Estado de México'],
            ['key' => 'MIC', 'value' => 'Michoacán'],
            ['key' => 'MOR', 'value' => 'Morelos'],
            ['key' => 'NAY', 'value' => 'Nayarit'],
            ['key' => 'NLE', 'value' => 'Nuevo León'],
            ['key' => 'OAX', 'value' => 'Oaxaca'],
            ['key' => 'PUE', 'value' => 'Puebla'],
            ['key' => 'QUE', 'value' => 'Querétaro'],
            ['key' => 'ROO', 'value' => 'Quintana Roo'],
            ['key' => 'SLP', 'value' => 'San Luis Potosí'],
            ['key' => 'SIN', 'value' => 'Sinaloa'],
            ['key' => 'SON', 'value' => 'Sonora'],
            ['key' => 'TAB', 'value' => 'Tabasco'],
            ['key' => 'TAM', 'value' => 'Tamaulipas'],
            ['key' => 'TLA', 'value' => 'Tlaxcala'],
            ['key' => 'VER', 'value' => 'Veracruz'],
            ['key' => 'YUC', 'value' => 'Yucatán'],
            ['key' => 'ZAC', 'value' => 'Zacatecas']
        ];
    }

    /**
     * Tipo de deducción
     */
    public static function getPayrollTypes() {
        return [
            ['key' => 'O', 'value' => 'Nómina ordinaria'],
            ['key' => 'E', 'value' => 'Nómina extraordinaria']
        ];
    }

    /**
     * Tipo de contrato
     */
    public static function getContractTypes() {
        return [
            ['key' => '01', 'value' => 'Contrato de trabajo por tiempo indeterminado'],
            ['key' => '02', 'value' => 'Contrato de trabajo para obra determinada'],
            ['key' => '03', 'value' => 'Contrato de trabajo por tiempo determinado'],
            ['key' => '04', 'value' => 'Contrato de trabajo por temporada'],
            ['key' => '05', 'value' => 'Contrato de trabajo sujeto a prueba'],
            ['key' => '06', 'value' => 'Contrato de trabajo con capacitación inicial'],
            ['key' => '07', 'value' => 'Modalidad de contratación por pago de hora laborada'],
            ['key' => '08', 'value' => 'Modalidad de trabajo por comisión laboral'],
            ['key' => '09', 'value' => 'Modalidades de contratación donde no existe relación de trabajo'],
            ['key' => '10', 'value' => 'Jubilación, pensión, retiro.'],
            ['key' => '99', 'value' => 'Otro contrato']
        ];
    }

    /**
     * Regimen type
     */
    public static function getRegimeTypes() {
        return [
            ['key' => '02', 'value' => 'Sueldos (Incluye ingresos señalados en la fracción I del artículo 94 de LISR)'],
            ['key' => '03', 'value' => 'Jubilados'],
            ['key' => '04', 'value' => 'Pensionados'],
            ['key' => '05', 'value' => 'Asimilados Miembros Sociedades Cooperativas Produccion'],
            ['key' => '06', 'value' => 'Asimilados Integrantes Sociedades Asociaciones Civiles'],
            ['key' => '07', 'value' => 'Asimilados Miembros consejos'],
            ['key' => '08', 'value' => 'Asimilados comisionistas'],
            ['key' => '09', 'value' => 'Asimilados Honorarios'],
            ['key' => '10', 'value' => 'Asimilados acciones'],
            ['key' => '11', 'value' => 'Asimilados otros'],
            ['key' => '12', 'value' => 'Jubilados o Pensionados'],
            ['key' => '13', 'value' => 'Indemnización o Separación'],
            ['key' => '99', 'value' => 'Otro Regimen']
        ];
    }

    /**
     * Riesgo de puesto
     */
    public static function getWorkstationRisks() {
        return [
            ['key' => '1', 'value' => 'Clase I'],
            ['key' => '2', 'value' => 'Clase II'],
            ['key' => '3', 'value' => 'Clase III'],
            ['key' => '4', 'value' => 'Clase IV'],
            ['key' => '5', 'value' => 'Clase V'],
            ['key' => '99', 'value' => 'No aplica']
        ];
    }

    /**
     * Periodicidad de pago
     */
    public static function getPaymentPeriod() {
        return [
            ['key' => '01', 'value' => 'Diario'],
            ['key' => '02', 'value' => 'Semanal'],
            ['key' => '03', 'value' => 'Catorcenal'],
            ['key' => '04', 'value' => 'Quincenal'],
            ['key' => '05', 'value' => 'Mensual'],
            ['key' => '06', 'value' => 'Bimestral'],
            ['key' => '07', 'value' => 'Unidad obra'],
            ['key' => '08', 'value' => 'Comisión'],
            ['key' => '09', 'value' => 'Precio alzado'],
            ['key' => '10', 'value' => 'Decenal'],
            ['key' => '99', 'value' => 'Otra periodicidad']
        ];
    }

    public static function getDeductionTypes() {
        return [
            ['key' => '001', 'value' => 'Seguridad social'],
            ['key' => '003', 'value' => 'Aportaciones a retiro, cesantía en edad avanzada y vejez.'],
            ['key' => '004', 'value' => 'Otros'],
            ['key' => '005', 'value' => 'Aportaciones a Fondo de vivienda'],
            ['key' => '006', 'value' => 'Descuento por incapacidad'],
            ['key' => '007', 'value' => 'Pensión alimenticia'],
            ['key' => '008', 'value' => 'Renta'],
            ['key' => '009', 'value' => 'Préstamos provenientes del Fondo Nacional de la Vivienda para los Trabajadores'],
            ['key' => '011', 'value' => 'Pago de abonos INFONACOT'],
            ['key' => '012', 'value' => 'Anticipo de salarios'],
            ['key' => '013', 'value' => 'Pagos hechos con exceso al trabajador'],
            ['key' => '014', 'value' => 'Errores'],
            ['key' => '015', 'value' => 'Pérdidas'],
            ['key' => '016', 'value' => 'Averías'],
            ['key' => '017', 'value' => 'Adquisición de artículos producidos por la empresa o establecimiento'],
            ['key' => '018', 'value' => 'Cuotas para la constitución y fomento de sociedades cooperativas y de cajas de ahorro'],
            ['key' => '019', 'value' => 'Cuotas sindicales'],
            ['key' => '020', 'value' => 'Ausencia (Ausentismo)'],
            ['key' => '022', 'value' => 'Impuestos Locales'],
            ['key' => '023', 'value' => 'Aportaciones voluntarias'],
            ['key' => '024', 'value' => 'Ajuste en Gratificación Anual (Aguinaldo) Exento'],
            ['key' => '025', 'value' => 'Ajuste en Gratificación Anual (Aguinaldo) Gravado'],
            ['key' => '026', 'value' => 'Ajuste en Participación de los Trabajadores en las Utilidades PTU Exento'],
            ['key' => '027', 'value' => 'Ajuste en Participación de los Trabajadores en las Utilidades PTU Gravado'],
            ['key' => '028', 'value' => 'Ajuste en Reembolso de Gastos Médicos Dentales y Hospitalarios Exento'],
            ['key' => '029', 'value' => 'Ajuste en Fondo de ahorro Exento'],
            ['key' => '030', 'value' => 'Ajuste en Caja de ahorro Exento'],
            ['key' => '031', 'value' => 'Ajuste en Contribuciones a Cargo del Trabajador Pagadas por el Patrón Exento'],
            ['key' => '032', 'value' => 'Ajuste en Premios por puntualidad Gravado'],
            ['key' => '033', 'value' => 'Ajuste en Prima de Seguro de vida Exento'],
            ['key' => '034', 'value' => 'Ajuste en Seguro de Gastos Médicos Mayores Exento'],
            ['key' => '035', 'value' => 'Ajuste en Cuotas Sindicales Pagadas por el Patrón Exento'],
            ['key' => '036', 'value' => 'Ajuste en Subsidios por incapacidad Exento'],
            ['key' => '037', 'value' => 'Ajuste en Becas para trabajadores y/o hijos Exento'],
            ['key' => '038', 'value' => 'Ajuste en Horas extra Exento'],
            ['key' => '039', 'value' => 'Ajuste en Horas extra Gravado'],
            ['key' => '040', 'value' => 'Ajuste en Prima dominical Exento'],
            ['key' => '041', 'value' => 'Ajuste en Prima dominical Gravado'],
            ['key' => '042', 'value' => 'Ajuste en Prima vacacional Exento'],
            ['key' => '043', 'value' => 'Ajuste en Prima vacacional Gravado'],
            ['key' => '044', 'value' => 'Ajuste en Prima por antigüedad Exento'],
            ['key' => '045', 'value' => 'Ajuste en Prima por antigüedad Gravado'],
            ['key' => '046', 'value' => 'Ajuste en Pagos por separación Exento'],
            ['key' => '047', 'value' => 'Ajuste en Pagos por separación Gravado'],
            ['key' => '048', 'value' => 'Ajuste en Seguro de retiro Exento'],
            ['key' => '049', 'value' => 'Ajuste en Indemnizaciones Exento'],
            ['key' => '050', 'value' => 'Ajuste en Indemnizaciones Gravado'],
            ['key' => '051', 'value' => 'Ajuste en Reembolso por funeral Exento'],
            ['key' => '052', 'value' => 'Ajuste en Cuotas de seguridad social pagadas por el patrón Exento'],
            ['key' => '053', 'value' => 'Ajuste en Comisiones Gravado'],
            ['key' => '054', 'value' => 'Ajuste en Vales de despensa Exento'],
            ['key' => '055', 'value' => 'Ajuste en Vales de restaurante Exento'],
            ['key' => '056', 'value' => 'Ajuste en Vales de gasolina Exento'],
            ['key' => '057', 'value' => 'Ajuste en Vales de ropa Exento'],
            ['key' => '058', 'value' => 'Ajuste en Ayuda para renta Exento'],
            ['key' => '059', 'value' => 'Ajuste en Ayuda para artículos escolares Exento'],
            ['key' => '060', 'value' => 'Ajuste en Ayuda para anteojos Exento'],
            ['key' => '061', 'value' => 'Ajuste en Ayuda para transporte Exento'],
            ['key' => '062', 'value' => 'Ajuste en Ayuda para gastos de funeral Exento'],
            ['key' => '063', 'value' => 'Ajuste en Otros ingresos por salarios Exento'],
            ['key' => '064', 'value' => 'Ajuste en Otros ingresos por salarios Gravado'],
            ['key' => '065', 'value' => 'Ajuste en Jubilaciones, pensiones o haberes de retiro en una sola exhibición Exento'],
            ['key' => '066', 'value' => 'Ajuste en Jubilaciones, pensiones o haberes de retiro en una sola exhibición Gravado'],
            ['key' => '067', 'value' => 'Ajuste en Pagos por separación Acumulable'],
            ['key' => '068', 'value' => 'Ajuste en Pagos por separación No acumulable'],
            ['key' => '069', 'value' => 'Ajuste en Jubilaciones, pensiones o haberes de retiro en parcialidades Exento'],
            ['key' => '070', 'value' => 'Ajuste en Jubilaciones, pensiones o haberes de retiro en parcialidades Gravado'],
            ['key' => '071', 'value' => 'Ajuste en Subsidio para el empleo (efectivamente entregado al trabajador)'],
            ['key' => '072', 'value' => 'Ajuste en Ingresos en acciones o títulos valor que representan bienes Exento'],
            ['key' => '073', 'value' => 'Ajuste en Ingresos en acciones o títulos valor que representan bienes Gravado'],
            ['key' => '074', 'value' => 'Ajuste en Alimentación Exento'],
            ['key' => '075', 'value' => 'Ajuste en Alimentación Gravado'],
            ['key' => '076', 'value' => 'Ajuste en Habitación Exento'],
            ['key' => '077', 'value' => 'Ajuste en Habitación Gravado'],
            ['key' => '078', 'value' => 'Ajuste en Premios por asistencia'],
            ['key' => '079', 'value' => 'Ajuste en Pagos distintos a los listados y que no deben considerarse como ingreso por sueldos, salarios o ingresos asimilados.'],
            ['key' => '080', 'value' => 'Ajuste en Viáticos gravados'],
            ['key' => '081', 'value' => 'Ajuste en Viáticos (entregados al trabajador)'],
            ['key' => '082', 'value' => 'Ajuste en Fondo de ahorro Gravado'],
            ['key' => '083', 'value' => 'Ajuste en Caja de ahorro Gravado'],
            ['key' => '084', 'value' => 'Ajuste en Prima de Seguro de vida Gravado'],
            ['key' => '085', 'value' => 'Ajuste en Seguro de Gastos Médicos Mayores Gravado'],
            ['key' => '086', 'value' => 'Ajuste en Subsidios por incapacidad Gravado'],
            ['key' => '087', 'value' => 'Ajuste en Becas para trabajadores y/o hijos Gravado'],
            ['key' => '088', 'value' => 'Ajuste en Seguro de retiro Gravado'],
            ['key' => '089', 'value' => 'Ajuste en Vales de despensa Gravado'],
            ['key' => '090', 'value' => 'Ajuste en Vales de restaurante Gravado'],
            ['key' => '091', 'value' => 'Ajuste en Vales de gasolina Gravado'],
            ['key' => '092', 'value' => 'Ajuste en Vales de ropa Gravado'],
            ['key' => '093', 'value' => 'Ajuste en Ayuda para renta Gravado'],
            ['key' => '094', 'value' => 'Ajuste en Ayuda para artículos escolares Gravado'],
            ['key' => '095', 'value' => 'Ajuste en Ayuda para anteojos Gravado'],
            ['key' => '096', 'value' => 'Ajuste en Ayuda para transporte Gravado'],
            ['key' => '097', 'value' => 'Ajuste en Ayuda para gastos de funeral Gravado'],
            ['key' => '098', 'value' => 'Ajuste a ingresos asimilados a salarios gravados'],
            ['key' => '099', 'value' => 'Ajuste a ingresos por sueldos y salarios gravados'],
            ['key' => '100', 'value' => 'Ajuste en Viáticos exentos'],
            ['key' => '101', 'value' => 'ISR Retenido de ejercicio anterior'],
            ['key' => '102', 'value' => 'Ajuste a pagos por gratificaciones, primas, compensaciones, recompensas u otros a extrabajadores derivados de jubilación en parcialidades, gravados'],
            ['key' => '103', 'value' => 'Ajuste a pagos que se realicen a extrabajadores que obtengan una jubilación en parcialidades derivados de la ejecución de una resolución judicial o de un laudo gravados'],
            ['key' => '104', 'value' => 'Ajuste a pagos que se realicen a extrabajadores que obtengan una jubilación en parcialidades derivados de la ejecución de una resolución judicial o de un laudo exentos'],
            ['key' => '105', 'value' => 'Ajuste a pagos que se realicen a extrabajadores que obtengan una jubilación en una sola exhibición derivados de la ejecución de una resolución judicial o de un laudo gravados'],
            ['key' => '106', 'value' => 'Ajuste a pagos que se realicen a extrabajadores que obtengan una jubilación en una sola exhibición derivados de la ejecución de una resolución judicial o de un laudo exentos'],
            ['key' => '107', 'value' => 'Ajuste al Subsidio Causado']
        ];
    }
}