<?php

namespace App\Http\Services;

/**
 * This is a value object for BaseConverter containing the sequence
 *
 * NOTE: Changes will not be considering a bracking compatibility change since this utility is for internal usage only
 * @internal
 */
class BaseConverterSequence
{
    /** @var string */
    private $sequence;

    /** @var int */
    private $length;

    public function __construct(string $sequence)
    {
        $this->sequence = $sequence;
        $this->length = strlen($sequence);
    }

    public function __toString(): string
    {
        return $this->sequence;
    }

    public function value(): string
    {
        return $this->sequence;
    }

    public function length(): int
    {
        return $this->length;
    }

}
