<?php

namespace App\Http\Controllers;

use App\Http\Services\CFDIService;
use App\Http\Services\DocumentServices;
use Barryvdh\DomPDF\PDF;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class SalariedController extends Controller
{
    /**
     * Handle the incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function __invoke(Request $request)
    {
        return view('salaried');
    }

    /**
     * Loads data from excel and converts to Payroll receipts
     */
    public function LoadFromExcel(Request $request) {
        $file = $request->file('fel_file');
        $excel = file_get_contents($file->getRealPath());
        $data = base64_encode($excel);
        $map = [
            [ 'column' => 'A', 'target' => 'no' ],
            [ 'column' => 'B', 'target' => 'name' ],
            [ 'column' => 'E', 'target' => 'rfc'  ],
            [ 'column' => 'F', 'target' => 'curp' ],
            [ 'column' => 'G', 'target' => 'salaryDay' ],
            [ 'column' => 'H', 'target' => 'factory' ],
            [ 'column' => 'J', 'target' => 'days' ],

            [ 'column' => 'AN', 'target' => 'SMG' ],
            [ 'column' => 'AO', 'target' => 'VSM' ],
            [ 'column' => 'AQ', 'target' => 'safe'  ],
            [ 'column' => 'AS', 'target' => 'bimesterDay' ],
            [ 'column' => 'AU', 'target' => 'workDays' ]
        ];

        $mapper = new MapperController();
        $employees = $mapper->getSalariedEmployees(
            $mapper->readExcel($data, $map)
        );

        $subsideMap = [
            [ 'column' => 'AF', 'target' => 'lowerLimit' ],
            [ 'column' => 'AG', 'target' => 'upperLimit' ],
            [ 'column' => 'AH', 'target' => 'fixedFee'  ],
            [ 'column' => 'AI', 'target' => 'percent' ],
            [ 'column' => 'AK', 'target' => 'income' ],
            [ 'column' => 'AL', 'target' => 'subside' ]
        ];
        $subsideTable = $mapper->getSubsideTable(
            $mapper->readExcel($data, $subsideMap)
        );

        $mapEmployees = $this->toMapEmployees($employees, $subsideTable);
        foreach ($mapEmployees as $emp) {
            Storage::disk('local')->put($emp['uid'] . '.xml', 
                $this->BuildPayrollReceipt($request, $emp));
        }
        $rfcEmisor = $request['rfc'];
        return view('invoice-list', compact('mapEmployees', 'rfcEmisor'));
    }

    /**
     * Involves a list of employees to response format
     */
    public function toMapEmployees($employees, $subsideTable) {
        $emps = array();
        foreach ($employees as $emp) {
            array_push($emps, 
                CFDIService::getSalariedEmployeeResponse($emp, $subsideTable)
            );
        }
        return $emps;
    }

        /**
     * Builds a payroll receipt on xml format 
     */
    private function BuildPayrollReceipt($request, $employee) {
        $periodicidad = "04";
        $ClaveEntFed = "NLE";
        $tipoRegimen = "11";
        $tipoNomina = "O";
        $days = 30;

        $date = date('Y-m-d\TH:i:s');
        $data = array(
            "Folio" => '0001',
            "Fecha" => $date,
            "Emisor" => array (
                "Rfc" => $request['rfc'],
                "Nombre" => $request['name']
            ),
            "Receptor" => array(
                "Rfc" => $employee['rfc'],
                "Nombre" => $employee['name'],
                "ClaveEntFed" => $ClaveEntFed,
                "NumEmpleado" => $employee['no'],
                "TipoRegimen" => $tipoRegimen,
                "curp" => $employee['curp']
            ),
            "Conceptos" => [
                array(
                    "Concepto" => array (
                        "ClaveProdServ" => "84111505"
                ))
            ],
            "nomina" => array(
                "dias" => $days,
                "FechaPago" => $request['pay_date'],
                "FechaInicialPago" => $request['pay_init'],
                "FechaFinalPago" => $request['pay_end'],
                "periodicidad" => $periodicidad,
                "tipoNomina" => $tipoNomina,
                "subtotal" => $employee['total'],
                "isr" => $employee['isr'],
                "imss" => $employee['imss'],
                "infonavit" => $employee['infonavit'],
                "subsidy" => $employee['subsidy'],
                "discount" => round($employee['imss'] + $employee['isr'] + $employee['infonavit'], 2),
                "total" => $employee['totalPayed']
            )
        );

        return SalariedController::getCFDI($data);
    }

    /**
     * Gets a xml content of CFDI
     */
    public static function getCFDI($data) {
        $cfdi = DocumentServices::buildAsalariedCFDI($data);
        $domxml = new \DOMDocument('1.0');
        $domxml->preserveWhiteSpace = false;
        $domxml->formatOutput = true;
        $domxml->loadXML($cfdi);
        return $domxml->saveXML();
    }
}
