<?php

namespace App\Http\Controllers\Requests;

use App\Http\Controllers\Controller;
use App\Model\Request as ModelRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SummaryController extends Controller
{
    /**
     * Shows a employee form for edit his data
     */
    public function show(Request $request, $id) {
        $request = ModelRequest::find($id);
        $employees = $request->employeesWithAll;
        
        return view('client.components.summary-request', [
            'record' => $request,
            'employeeScatters' => $employees,
            'emailAction' => 'reject'
        ]);
    }
}
