<?php

namespace App\Http\Controllers\Requests;

use App\Http\Controllers\Controller;
use App\Model\Bank;
use App\Model\BankHistory;
use App\Model\Employee;
use App\Model\EmployeeScatter;
use App\Model\Partnership;
use App\Model\Request as ModelRequest;
use App\Model\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;

class ScatterController extends Controller
{
    
    /**
     * Shows a form for edit a invoices
     */
    public function show(Request $request, $id) {
        return $this->store($request, $id);
    }

    /**
     * saves scatter employees
     */
    public function store(Request $request, $id) {
        $page = $request->input('page', 0);
        $search = $request->input('search');
        $record = ModelRequest::find($id);
        $partnership = $record->businessClient->partnership;

        $sort = 'employees.rfc';
        $sortOrientation = 'asc';
        $sortTokens = $request->input('sort', 'employees.rfc:asc');
        if (strpos($sortTokens, ':') != false) {
            list($sort, $sortOrientation) = explode(':', $sortTokens);
        } else {
            $sort = $sortTokens;
        }

        if (!$record->isRequestComplete()) {
            $dataHistory = [];
            $count = 0;
            if ($request->has('employee-id')) {
                $count = count($request->input('employee-id'));
            }

            for ($i = 0; $i < $count; $i++) {
                $scatter = $record->getEmployee($request->input('employee-id')[$i]);
                if ($request->input('amount')[$i]) {
                    if (!$scatter) {
                        $scatter = new EmployeeScatter();
                        $scatter->employee_id = $request->input('employee-id')[$i];
                    }
                    $scatter->request()->associate($record);
                    $scatter->bank_id = $request->input('bank')[$i];
                    if ($request->input('account')[$i]) {
                        $scatter->account = $request->input('account')[$i];
                    } else {
                        $scatter->account = '';
                    }
                    $scatter->status = 'O';

                    $scatter->addPendingAmount($request->input('amount')[$i]);
                    $scatter->save();

                    $scatter->refresh();
                    if ($scatter->HasChangesBank()) {
                        $employee = $scatter->employee;
                        array_push($dataHistory, [
                            'employeeNumber' => $employee->employee_number,
                            'employee' => $employee->getFullName(),
                            'previousAccount' => $employee->account,
                            'previousBank' => $employee->bank ? $employee->bank->name : '',
                            'currentAccount' => $scatter->account,
                            'currentBank' => $scatter->bank ? $scatter->bank->name : ''
                        ]);

                        $history = new BankHistory();
                        $history->bank_id = $scatter->bank_id;
                        $history->account = $scatter->account;
                        $history->user_id = Auth::id();
                        $history->employee_id = $scatter->employee_id;
                        $history->request_id = $scatter->request_id;
                        $history->save();

                        $employee->bank_id = $scatter->bank_id;
                        $employee->account = $scatter->account;
                        $employee->save();
                    }
                } else if ($scatter && $scatter->amount == 0) {
                    $details = $scatter->scatterDetails;
                    foreach ($details as $det) {
                        $det->delete();
                    }
                    $scatter->delete();
                }
            }

            if (count($dataHistory) > 0) {
                $partnership = Auth::user()->partnership();
                $data = array(
                    'user'=> Auth::user(),
                    'partnership' => $partnership,
                    'data' => $dataHistory
                );
                
                $users = User::select('email')
                    ->where('type', 'BA')
                    ->get();
                Log::info('Enviando correo de cambios bancarios');                                
                Mail::send('emails.bank-history', $data, function($message) use ($users, $partnership) {
                    $message->from('noreply@silifalcon.com', 'BB DESPACHO INTEGRAL DE SERVICIOS SA DE CV');
                    $message->subject('Cambios en datos bancarios de ' . $partnership->code);
                    foreach ($users as $user) {
                        $email = str_replace(" ", "", $user->email);
                        if ($email != '' && strpos($email, '@') !== false) {
                            $message->to(str_replace(" ", "", $email));
                        }
                    }
                });
            }
        }
        $query = Employee::select('employees.id', 'employees.name', 'employees.last_name', 'employees.last_name2', 
            'employees.rfc', 'employees.bank_id', 'employees.account', 'employee_scatters.amount')
            ->leftJoin('employee_scatters', function ($join) use ($id) {
                $join->on('employee_scatters.employee_id', '=', 'employees.id')
                    ->where('employee_scatters.request_id', $id);
            })
            ->where('employees.partnership_id', $partnership->id)
            ->where('employees.status', 'R')
            ->whereNull('employees.canceled_at')
            ->orderBy($sort, $sortOrientation)
            ->distinct();
        
        if ($search) {
            $query = $query->where(function ($query) use($search) {
                $query->where(DB::raw('concat(employees.name, " ", ' . 'employees.last_name, " ", employees.last_name2)'), 
                    'like', '%' . $search . '%')
                    ->orWhere('employees.rfc', 'like', '%' . $search . '%');
            });
        }
        $total = $query->count();
        $employees = $query->skip($page * 25)->take(25)->get();
        $data = [];
        $record->refresh();
        foreach ($employees as $employee) {
            $scatter = $record->getEmployee($employee->id);
            if (!$scatter) {
                $scatter = new EmployeeScatter();
                $scatter->request_id = $id;
                $scatter->employee()->associate($employee);
                $scatter->account = $employee->account;
                $scatter->bank_id = $employee->bank_id;
            }
            array_push($data, $scatter);
        }
        return view('client.components.scatter', [
            'partnership' => $partnership,
            'record' => $record,
            'banks' => Bank::all(),
            'totalScatter' => $record->getTotalScatter(), //DB::table("employee_scatters")->where('request_id', $id)->get()->sum("amount"),
            'data' => $data,
            'total' => $total,
            'page' => $page,
            'search' => $search,
            'sort' => $sort,
            'sortOrientation' => $sortOrientation,
            'pages' => ceil($total / 25)
        ]);
    }

}